package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTrafficDistributionGroupUsersResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    trafficDistributionGroupUserSummaryList: Optional[
      Iterable[zio.aws.connect.model.TrafficDistributionGroupUserSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse = {
    import ListTrafficDistributionGroupUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        trafficDistributionGroupUserSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trafficDistributionGroupUserSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListTrafficDistributionGroupUsersResponse.ReadOnly =
    zio.aws.connect.model.ListTrafficDistributionGroupUsersResponse
      .wrap(buildAwsValue())
}
object ListTrafficDistributionGroupUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.ListTrafficDistributionGroupUsersResponse =
      zio.aws.connect.model.ListTrafficDistributionGroupUsersResponse(
        nextToken.map(value => value),
        trafficDistributionGroupUserSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def trafficDistributionGroupUserSummaryList: Optional[
      List[zio.aws.connect.model.TrafficDistributionGroupUserSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrafficDistributionGroupUserSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TrafficDistributionGroupUserSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trafficDistributionGroupUserSummaryList",
      trafficDistributionGroupUserSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse
  ) extends zio.aws.connect.model.ListTrafficDistributionGroupUsersResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val trafficDistributionGroupUserSummaryList: Optional[
      List[zio.aws.connect.model.TrafficDistributionGroupUserSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficDistributionGroupUserSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.TrafficDistributionGroupUserSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse
  ): zio.aws.connect.model.ListTrafficDistributionGroupUsersResponse.ReadOnly =
    new Wrapper(impl)
}
