package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken,
  IntegrationAssociationId,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUseCasesRequest(
    instanceId: InstanceId,
    integrationAssociationId: IntegrationAssociationId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListUseCasesRequest = {
    import ListUseCasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListUseCasesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .integrationAssociationId(
        IntegrationAssociationId.unwrap(
          integrationAssociationId
        ): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListUseCasesRequest.ReadOnly =
    zio.aws.connect.model.ListUseCasesRequest.wrap(buildAwsValue())
}
object ListUseCasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListUseCasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListUseCasesRequest =
      zio.aws.connect.model.ListUseCasesRequest(
        instanceId,
        integrationAssociationId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def integrationAssociationId: IntegrationAssociationId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getIntegrationAssociationId
        : ZIO[Any, Nothing, IntegrationAssociationId] =
      ZIO.succeed(integrationAssociationId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListUseCasesRequest
  ) extends zio.aws.connect.model.ListUseCasesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val integrationAssociationId: IntegrationAssociationId =
      zio.aws.connect.model.primitives
        .IntegrationAssociationId(impl.integrationAssociationId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListUseCasesRequest
  ): zio.aws.connect.model.ListUseCasesRequest.ReadOnly = new Wrapper(impl)
}
