package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListUserHierarchyGroupsResponse(
    userHierarchyGroupSummaryList: Optional[
      Iterable[zio.aws.connect.model.HierarchyGroupSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse = {
    import ListUserHierarchyGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse
      .builder()
      .optionallyWith(
        userHierarchyGroupSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userHierarchyGroupSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly =
    zio.aws.connect.model.ListUserHierarchyGroupsResponse.wrap(buildAwsValue())
}
object ListUserHierarchyGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListUserHierarchyGroupsResponse =
      zio.aws.connect.model.ListUserHierarchyGroupsResponse(
        userHierarchyGroupSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userHierarchyGroupSummaryList
        : Optional[List[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getUserHierarchyGroupSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HierarchyGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userHierarchyGroupSummaryList",
      userHierarchyGroupSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse
  ) extends zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly {
    override val userHierarchyGroupSummaryList
        : Optional[List[zio.aws.connect.model.HierarchyGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userHierarchyGroupSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.HierarchyGroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse
  ): zio.aws.connect.model.ListUserHierarchyGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
