package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListUsersResponse(
    userSummaryList: Optional[Iterable[zio.aws.connect.model.UserSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListUsersResponse
      .builder()
      .optionallyWith(
        userSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListUsersResponse.ReadOnly =
    zio.aws.connect.model.ListUsersResponse.wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListUsersResponse =
      zio.aws.connect.model.ListUsersResponse(
        userSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userSummaryList
        : Optional[List[zio.aws.connect.model.UserSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getUserSummaryList
        : ZIO[Any, AwsError, List[zio.aws.connect.model.UserSummary.ReadOnly]] =
      AwsError.unwrapOptionField("userSummaryList", userSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListUsersResponse
  ) extends zio.aws.connect.model.ListUsersResponse.ReadOnly {
    override val userSummaryList
        : Optional[List[zio.aws.connect.model.UserSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.UserSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListUsersResponse
  ): zio.aws.connect.model.ListUsersResponse.ReadOnly = new Wrapper(impl)
}
