package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResults,
  ViewsNextToken,
  ViewId,
  ViewsInstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListViewVersionsRequest(
    instanceId: ViewsInstanceId,
    viewId: ViewId,
    nextToken: Optional[ViewsNextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListViewVersionsRequest = {
    import ListViewVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListViewVersionsRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .viewId(ViewId.unwrap(viewId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => ViewsNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListViewVersionsRequest.ReadOnly =
    zio.aws.connect.model.ListViewVersionsRequest.wrap(buildAwsValue())
}
object ListViewVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListViewVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListViewVersionsRequest =
      zio.aws.connect.model.ListViewVersionsRequest(
        instanceId,
        viewId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: ViewsInstanceId
    def viewId: ViewId
    def nextToken: Optional[ViewsNextToken]
    def maxResults: Optional[MaxResults]
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getViewId: ZIO[Any, Nothing, ViewId] = ZIO.succeed(viewId)
    def getNextToken: ZIO[Any, AwsError, ViewsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListViewVersionsRequest
  ) extends zio.aws.connect.model.ListViewVersionsRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val viewId: ViewId =
      zio.aws.connect.model.primitives.ViewId(impl.viewId())
    override val nextToken: Optional[ViewsNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.ViewsNextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListViewVersionsRequest
  ): zio.aws.connect.model.ListViewVersionsRequest.ReadOnly = new Wrapper(impl)
}
