package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ViewsNextToken
import scala.jdk.CollectionConverters._
final case class ListViewVersionsResponse(
    viewVersionSummaryList: Optional[
      Iterable[zio.aws.connect.model.ViewVersionSummary]
    ] = Optional.Absent,
    nextToken: Optional[ViewsNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListViewVersionsResponse = {
    import ListViewVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListViewVersionsResponse
      .builder()
      .optionallyWith(
        viewVersionSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.viewVersionSummaryList)
      .optionallyWith(
        nextToken.map(value => ViewsNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListViewVersionsResponse.ReadOnly =
    zio.aws.connect.model.ListViewVersionsResponse.wrap(buildAwsValue())
}
object ListViewVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListViewVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListViewVersionsResponse =
      zio.aws.connect.model.ListViewVersionsResponse(
        viewVersionSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def viewVersionSummaryList
        : Optional[List[zio.aws.connect.model.ViewVersionSummary.ReadOnly]]
    def nextToken: Optional[ViewsNextToken]
    def getViewVersionSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ViewVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "viewVersionSummaryList",
      viewVersionSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, ViewsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListViewVersionsResponse
  ) extends zio.aws.connect.model.ListViewVersionsResponse.ReadOnly {
    override val viewVersionSummaryList
        : Optional[List[zio.aws.connect.model.ViewVersionSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewVersionSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ViewVersionSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[ViewsNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.ViewsNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListViewVersionsResponse
  ): zio.aws.connect.model.ListViewVersionsResponse.ReadOnly = new Wrapper(impl)
}
