package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResults,
  ViewsNextToken,
  ViewsInstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListViewsRequest(
    instanceId: ViewsInstanceId,
    `type`: Optional[zio.aws.connect.model.ViewType] = Optional.Absent,
    nextToken: Optional[ViewsNextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListViewsRequest = {
    import ListViewsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListViewsRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        nextToken.map(value => ViewsNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListViewsRequest.ReadOnly =
    zio.aws.connect.model.ListViewsRequest.wrap(buildAwsValue())
}
object ListViewsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListViewsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListViewsRequest =
      zio.aws.connect.model.ListViewsRequest(
        instanceId,
        `type`.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: ViewsInstanceId
    def `type`: Optional[zio.aws.connect.model.ViewType]
    def nextToken: Optional[ViewsNextToken]
    def maxResults: Optional[MaxResults]
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.ViewType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNextToken: ZIO[Any, AwsError, ViewsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListViewsRequest
  ) extends zio.aws.connect.model.ListViewsRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val `type`: Optional[zio.aws.connect.model.ViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.ViewType.wrap(value))
    override val nextToken: Optional[ViewsNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.ViewsNextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListViewsRequest
  ): zio.aws.connect.model.ListViewsRequest.ReadOnly = new Wrapper(impl)
}
