package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ViewsNextToken
import scala.jdk.CollectionConverters._
final case class ListViewsResponse(
    viewsSummaryList: Optional[Iterable[zio.aws.connect.model.ViewSummary]] =
      Optional.Absent,
    nextToken: Optional[ViewsNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListViewsResponse = {
    import ListViewsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListViewsResponse
      .builder()
      .optionallyWith(
        viewsSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.viewsSummaryList)
      .optionallyWith(
        nextToken.map(value => ViewsNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListViewsResponse.ReadOnly =
    zio.aws.connect.model.ListViewsResponse.wrap(buildAwsValue())
}
object ListViewsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListViewsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListViewsResponse =
      zio.aws.connect.model.ListViewsResponse(
        viewsSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def viewsSummaryList
        : Optional[List[zio.aws.connect.model.ViewSummary.ReadOnly]]
    def nextToken: Optional[ViewsNextToken]
    def getViewsSummaryList
        : ZIO[Any, AwsError, List[zio.aws.connect.model.ViewSummary.ReadOnly]] =
      AwsError.unwrapOptionField("viewsSummaryList", viewsSummaryList)
    def getNextToken: ZIO[Any, AwsError, ViewsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListViewsResponse
  ) extends zio.aws.connect.model.ListViewsResponse.ReadOnly {
    override val viewsSummaryList
        : Optional[List[zio.aws.connect.model.ViewSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewsSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ViewSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[ViewsNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.ViewsNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListViewsResponse
  ): zio.aws.connect.model.ListViewsResponse.ReadOnly = new Wrapper(impl)
}
