package zio.aws.connect.model
import zio.aws.connect.model.primitives.Concurrency
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MediaConcurrency(
    channel: zio.aws.connect.model.Channel,
    concurrency: Concurrency,
    crossChannelBehavior: Optional[zio.aws.connect.model.CrossChannelBehavior] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MediaConcurrency = {
    import MediaConcurrency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MediaConcurrency
      .builder()
      .channel(channel.unwrap)
      .concurrency(Concurrency.unwrap(concurrency): Integer)
      .optionallyWith(crossChannelBehavior.map(value => value.buildAwsValue()))(
        _.crossChannelBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MediaConcurrency.ReadOnly =
    zio.aws.connect.model.MediaConcurrency.wrap(buildAwsValue())
}
object MediaConcurrency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MediaConcurrency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MediaConcurrency =
      zio.aws.connect.model.MediaConcurrency(
        channel,
        concurrency,
        crossChannelBehavior.map(value => value.asEditable)
      )
    def channel: zio.aws.connect.model.Channel
    def concurrency: Concurrency
    def crossChannelBehavior
        : Optional[zio.aws.connect.model.CrossChannelBehavior.ReadOnly]
    def getChannel: ZIO[Any, Nothing, zio.aws.connect.model.Channel] =
      ZIO.succeed(channel)
    def getConcurrency: ZIO[Any, Nothing, Concurrency] =
      ZIO.succeed(concurrency)
    def getCrossChannelBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.CrossChannelBehavior.ReadOnly
    ] = AwsError.unwrapOptionField("crossChannelBehavior", crossChannelBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MediaConcurrency
  ) extends zio.aws.connect.model.MediaConcurrency.ReadOnly {
    override val channel: zio.aws.connect.model.Channel =
      zio.aws.connect.model.Channel.wrap(impl.channel())
    override val concurrency: Concurrency =
      zio.aws.connect.model.primitives.Concurrency(impl.concurrency())
    override val crossChannelBehavior
        : Optional[zio.aws.connect.model.CrossChannelBehavior.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossChannelBehavior())
        .map(value => zio.aws.connect.model.CrossChannelBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MediaConcurrency
  ): zio.aws.connect.model.MediaConcurrency.ReadOnly = new Wrapper(impl)
}
