package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.Value
import scala.jdk.CollectionConverters._
final case class MetricDataV2(
    metric: Optional[zio.aws.connect.model.MetricV2] = Optional.Absent,
    value: Optional[Value] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MetricDataV2 = {
    import MetricDataV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MetricDataV2
      .builder()
      .optionallyWith(metric.map(value => value.buildAwsValue()))(_.metric)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MetricDataV2.ReadOnly =
    zio.aws.connect.model.MetricDataV2.wrap(buildAwsValue())
}
object MetricDataV2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MetricDataV2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MetricDataV2 =
      zio.aws.connect.model.MetricDataV2(
        metric.map(value => value.asEditable),
        value.map(value => value)
      )
    def metric: Optional[zio.aws.connect.model.MetricV2.ReadOnly]
    def value: Optional[Value]
    def getMetric: ZIO[Any, AwsError, zio.aws.connect.model.MetricV2.ReadOnly] =
      AwsError.unwrapOptionField("metric", metric)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MetricDataV2
  ) extends zio.aws.connect.model.MetricDataV2.ReadOnly {
    override val metric: Optional[zio.aws.connect.model.MetricV2.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metric())
        .map(value => zio.aws.connect.model.MetricV2.wrap(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.connect.model.primitives.Value(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MetricDataV2
  ): zio.aws.connect.model.MetricDataV2.ReadOnly = new Wrapper(impl)
}
