package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricFilterV2(
    metricFilterKey: Optional[String] = Optional.Absent,
    metricFilterValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MetricFilterV2 = {
    import MetricFilterV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MetricFilterV2
      .builder()
      .optionallyWith(metricFilterKey.map(value => value: java.lang.String))(
        _.metricFilterKey
      )
      .optionallyWith(
        metricFilterValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.metricFilterValues)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MetricFilterV2.ReadOnly =
    zio.aws.connect.model.MetricFilterV2.wrap(buildAwsValue())
}
object MetricFilterV2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MetricFilterV2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MetricFilterV2 =
      zio.aws.connect.model.MetricFilterV2(
        metricFilterKey.map(value => value),
        metricFilterValues.map(value => value)
      )
    def metricFilterKey: Optional[String]
    def metricFilterValues: Optional[List[String]]
    def getMetricFilterKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metricFilterKey", metricFilterKey)
    def getMetricFilterValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("metricFilterValues", metricFilterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MetricFilterV2
  ) extends zio.aws.connect.model.MetricFilterV2.ReadOnly {
    override val metricFilterKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metricFilterKey())
      .map(value => value: String)
    override val metricFilterValues: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricFilterValues())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MetricFilterV2
  ): zio.aws.connect.model.MetricFilterV2.ReadOnly = new Wrapper(impl)
}
