package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{DimensionsV2Value, DimensionsV2Key}
import scala.jdk.CollectionConverters._
final case class MetricResultV2(
    dimensions: Optional[Map[DimensionsV2Key, DimensionsV2Value]] =
      Optional.Absent,
    collections: Optional[Iterable[zio.aws.connect.model.MetricDataV2]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MetricResultV2 = {
    import MetricResultV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MetricResultV2
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value
            .map({ case (key, value) =>
              (DimensionsV2Key
                .unwrap(key): java.lang.String) -> (DimensionsV2Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dimensions)
      .optionallyWith(
        collections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collections)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MetricResultV2.ReadOnly =
    zio.aws.connect.model.MetricResultV2.wrap(buildAwsValue())
}
object MetricResultV2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MetricResultV2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MetricResultV2 =
      zio.aws.connect.model.MetricResultV2(
        dimensions.map(value => value),
        collections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dimensions: Optional[Map[DimensionsV2Key, DimensionsV2Value]]
    def collections: Optional[List[zio.aws.connect.model.MetricDataV2.ReadOnly]]
    def getDimensions
        : ZIO[Any, AwsError, Map[DimensionsV2Key, DimensionsV2Value]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getCollections: ZIO[Any, AwsError, List[
      zio.aws.connect.model.MetricDataV2.ReadOnly
    ]] = AwsError.unwrapOptionField("collections", collections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MetricResultV2
  ) extends zio.aws.connect.model.MetricResultV2.ReadOnly {
    override val dimensions: Optional[Map[DimensionsV2Key, DimensionsV2Value]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.DimensionsV2Key(
                key
              ) -> zio.aws.connect.model.primitives.DimensionsV2Value(value)
            })
            .toMap
        )
    override val collections
        : Optional[List[zio.aws.connect.model.MetricDataV2.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.MetricDataV2.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MetricResultV2
  ): zio.aws.connect.model.MetricResultV2.ReadOnly = new Wrapper(impl)
}
