package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.MetricNameV2
import scala.jdk.CollectionConverters._
final case class MetricV2(
    name: Optional[MetricNameV2] = Optional.Absent,
    threshold: Optional[Iterable[zio.aws.connect.model.ThresholdV2]] =
      Optional.Absent,
    metricFilters: Optional[Iterable[zio.aws.connect.model.MetricFilterV2]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MetricV2 = {
    import MetricV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MetricV2
      .builder()
      .optionallyWith(
        name.map(value => MetricNameV2.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        threshold.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threshold)
      .optionallyWith(
        metricFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricFilters)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MetricV2.ReadOnly =
    zio.aws.connect.model.MetricV2.wrap(buildAwsValue())
}
object MetricV2 {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.MetricV2] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MetricV2 =
      zio.aws.connect.model.MetricV2(
        name.map(value => value),
        threshold.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[MetricNameV2]
    def threshold: Optional[List[zio.aws.connect.model.ThresholdV2.ReadOnly]]
    def metricFilters
        : Optional[List[zio.aws.connect.model.MetricFilterV2.ReadOnly]]
    def getName: ZIO[Any, AwsError, MetricNameV2] =
      AwsError.unwrapOptionField("name", name)
    def getThreshold
        : ZIO[Any, AwsError, List[zio.aws.connect.model.ThresholdV2.ReadOnly]] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getMetricFilters: ZIO[Any, AwsError, List[
      zio.aws.connect.model.MetricFilterV2.ReadOnly
    ]] = AwsError.unwrapOptionField("metricFilters", metricFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MetricV2
  ) extends zio.aws.connect.model.MetricV2.ReadOnly {
    override val name: Optional[MetricNameV2] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.MetricNameV2(value))
    override val threshold
        : Optional[List[zio.aws.connect.model.ThresholdV2.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threshold())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ThresholdV2.wrap(item)
          }.toList
        )
    override val metricFilters
        : Optional[List[zio.aws.connect.model.MetricFilterV2.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.MetricFilterV2.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MetricV2
  ): zio.aws.connect.model.MetricV2.ReadOnly = new Wrapper(impl)
}
