package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait MonitorCapability {
  def unwrap: software.amazon.awssdk.services.connect.model.MonitorCapability
}
object MonitorCapability {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.MonitorCapability
  ): zio.aws.connect.model.MonitorCapability = value match {
    case software.amazon.awssdk.services.connect.model.MonitorCapability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.MonitorCapability.SILENT_MONITOR =>
      val r = SILENT_MONITOR
      r
    case software.amazon.awssdk.services.connect.model.MonitorCapability.BARGE =>
      val r = BARGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.MonitorCapability {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.MonitorCapability =
      software.amazon.awssdk.services.connect.model.MonitorCapability.UNKNOWN_TO_SDK_VERSION
  }
  case object SILENT_MONITOR extends zio.aws.connect.model.MonitorCapability {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.MonitorCapability =
      software.amazon.awssdk.services.connect.model.MonitorCapability.SILENT_MONITOR
  }
  case object BARGE extends zio.aws.connect.model.MonitorCapability {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.MonitorCapability =
      software.amazon.awssdk.services.connect.model.MonitorCapability.BARGE
  }
}
