package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ClientToken,
  AgentResourceId,
  ContactId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class MonitorContactRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    userId: AgentResourceId,
    allowedMonitorCapabilities: Optional[
      Iterable[zio.aws.connect.model.MonitorCapability]
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MonitorContactRequest = {
    import MonitorContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MonitorContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .userId(AgentResourceId.unwrap(userId): java.lang.String)
      .optionallyWith(
        allowedMonitorCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.allowedMonitorCapabilitiesWithStrings)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MonitorContactRequest.ReadOnly =
    zio.aws.connect.model.MonitorContactRequest.wrap(buildAwsValue())
}
object MonitorContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MonitorContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MonitorContactRequest =
      zio.aws.connect.model.MonitorContactRequest(
        instanceId,
        contactId,
        userId,
        allowedMonitorCapabilities.map(value => value),
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def userId: AgentResourceId
    def allowedMonitorCapabilities
        : Optional[List[zio.aws.connect.model.MonitorCapability]]
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getUserId: ZIO[Any, Nothing, AgentResourceId] = ZIO.succeed(userId)
    def getAllowedMonitorCapabilities
        : ZIO[Any, AwsError, List[zio.aws.connect.model.MonitorCapability]] =
      AwsError.unwrapOptionField(
        "allowedMonitorCapabilities",
        allowedMonitorCapabilities
      )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MonitorContactRequest
  ) extends zio.aws.connect.model.MonitorContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val userId: AgentResourceId =
      zio.aws.connect.model.primitives.AgentResourceId(impl.userId())
    override val allowedMonitorCapabilities
        : Optional[List[zio.aws.connect.model.MonitorCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedMonitorCapabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.MonitorCapability.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MonitorContactRequest
  ): zio.aws.connect.model.MonitorContactRequest.ReadOnly = new Wrapper(impl)
}
