package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, ContactId}
import scala.jdk.CollectionConverters._
final case class MonitorContactResponse(
    contactId: Optional[ContactId] = Optional.Absent,
    contactArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.MonitorContactResponse = {
    import MonitorContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.MonitorContactResponse
      .builder()
      .optionallyWith(
        contactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.contactId)
      .optionallyWith(
        contactArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.contactArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.MonitorContactResponse.ReadOnly =
    zio.aws.connect.model.MonitorContactResponse.wrap(buildAwsValue())
}
object MonitorContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.MonitorContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.MonitorContactResponse =
      zio.aws.connect.model.MonitorContactResponse(
        contactId.map(value => value),
        contactArn.map(value => value)
      )
    def contactId: Optional[ContactId]
    def contactArn: Optional[ARN]
    def getContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getContactArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("contactArn", contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.MonitorContactResponse
  ) extends zio.aws.connect.model.MonitorContactResponse.ReadOnly {
    override val contactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val contactArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.contactArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.MonitorContactResponse
  ): zio.aws.connect.model.MonitorContactResponse.ReadOnly = new Wrapper(impl)
}
