package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait NotificationContentType {
  def unwrap
      : software.amazon.awssdk.services.connect.model.NotificationContentType
}
object NotificationContentType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.NotificationContentType
  ): zio.aws.connect.model.NotificationContentType = value match {
    case software.amazon.awssdk.services.connect.model.NotificationContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.NotificationContentType.PLAIN_TEXT =>
      val r = PLAIN_TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.NotificationContentType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.NotificationContentType =
      software.amazon.awssdk.services.connect.model.NotificationContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAIN_TEXT extends zio.aws.connect.model.NotificationContentType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.NotificationContentType =
      software.amazon.awssdk.services.connect.model.NotificationContentType.PLAIN_TEXT
  }
}
