package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait NotificationDeliveryType {
  def unwrap
      : software.amazon.awssdk.services.connect.model.NotificationDeliveryType
}
object NotificationDeliveryType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.NotificationDeliveryType
  ): zio.aws.connect.model.NotificationDeliveryType = value match {
    case software.amazon.awssdk.services.connect.model.NotificationDeliveryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.NotificationDeliveryType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.NotificationDeliveryType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.NotificationDeliveryType =
      software.amazon.awssdk.services.connect.model.NotificationDeliveryType.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL extends zio.aws.connect.model.NotificationDeliveryType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.NotificationDeliveryType =
      software.amazon.awssdk.services.connect.model.NotificationDeliveryType.EMAIL
  }
}
