package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.UserId
import scala.jdk.CollectionConverters._
final case class NotificationRecipientType(
    userTags: Optional[Map[String, String]] = Optional.Absent,
    userIds: Optional[Iterable[UserId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.NotificationRecipientType = {
    import NotificationRecipientType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.NotificationRecipientType
      .builder()
      .optionallyWith(
        userTags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.userTags)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.NotificationRecipientType.ReadOnly =
    zio.aws.connect.model.NotificationRecipientType.wrap(buildAwsValue())
}
object NotificationRecipientType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.NotificationRecipientType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.NotificationRecipientType =
      zio.aws.connect.model.NotificationRecipientType(
        userTags.map(value => value),
        userIds.map(value => value)
      )
    def userTags: Optional[Map[String, String]]
    def userIds: Optional[List[UserId]]
    def getUserTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("userTags", userTags)
    def getUserIds: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.NotificationRecipientType
  ) extends zio.aws.connect.model.NotificationRecipientType.ReadOnly {
    override val userTags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.userTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val userIds: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.UserId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.NotificationRecipientType
  ): zio.aws.connect.model.NotificationRecipientType.ReadOnly = new Wrapper(
    impl
  )
}
