package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ReferenceValue, ReferenceKey}
import scala.jdk.CollectionConverters._
final case class NumberReference(
    name: Optional[ReferenceKey] = Optional.Absent,
    value: Optional[ReferenceValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.NumberReference = {
    import NumberReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.NumberReference
      .builder()
      .optionallyWith(
        name.map(value => ReferenceKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => ReferenceValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.NumberReference.ReadOnly =
    zio.aws.connect.model.NumberReference.wrap(buildAwsValue())
}
object NumberReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.NumberReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.NumberReference =
      zio.aws.connect.model
        .NumberReference(name.map(value => value), value.map(value => value))
    def name: Optional[ReferenceKey]
    def value: Optional[ReferenceValue]
    def getName: ZIO[Any, AwsError, ReferenceKey] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ReferenceValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.NumberReference
  ) extends zio.aws.connect.model.NumberReference.ReadOnly {
    override val name: Optional[ReferenceKey] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ReferenceKey(value))
    override val value: Optional[ReferenceValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.connect.model.primitives.ReferenceValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.NumberReference
  ): zio.aws.connect.model.NumberReference.ReadOnly = new Wrapper(impl)
}
