package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.DisplayName
import scala.jdk.CollectionConverters._
final case class ParticipantDetailsToAdd(
    participantRole: Optional[zio.aws.connect.model.ParticipantRole] =
      Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ParticipantDetailsToAdd = {
    import ParticipantDetailsToAdd.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ParticipantDetailsToAdd
      .builder()
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ParticipantDetailsToAdd.ReadOnly =
    zio.aws.connect.model.ParticipantDetailsToAdd.wrap(buildAwsValue())
}
object ParticipantDetailsToAdd {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ParticipantDetailsToAdd
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ParticipantDetailsToAdd =
      zio.aws.connect.model.ParticipantDetailsToAdd(
        participantRole.map(value => value),
        displayName.map(value => value)
      )
    def participantRole: Optional[zio.aws.connect.model.ParticipantRole]
    def displayName: Optional[DisplayName]
    def getParticipantRole
        : ZIO[Any, AwsError, zio.aws.connect.model.ParticipantRole] =
      AwsError.unwrapOptionField("participantRole", participantRole)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ParticipantDetailsToAdd
  ) extends zio.aws.connect.model.ParticipantDetailsToAdd.ReadOnly {
    override val participantRole
        : Optional[zio.aws.connect.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value => zio.aws.connect.model.ParticipantRole.wrap(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.connect.model.primitives.DisplayName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ParticipantDetailsToAdd
  ): zio.aws.connect.model.ParticipantDetailsToAdd.ReadOnly = new Wrapper(impl)
}
