package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ParticipantRole {
  def unwrap: software.amazon.awssdk.services.connect.model.ParticipantRole
}
object ParticipantRole {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ParticipantRole
  ): zio.aws.connect.model.ParticipantRole = value match {
    case software.amazon.awssdk.services.connect.model.ParticipantRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ParticipantRole.AGENT =>
      val r = AGENT
      r
    case software.amazon.awssdk.services.connect.model.ParticipantRole.CUSTOMER =>
      val r = CUSTOMER
      r
    case software.amazon.awssdk.services.connect.model.ParticipantRole.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.connect.model.ParticipantRole.CUSTOM_BOT =>
      val r = CUSTOM_BOT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantRole =
      software.amazon.awssdk.services.connect.model.ParticipantRole.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT extends zio.aws.connect.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantRole =
      software.amazon.awssdk.services.connect.model.ParticipantRole.AGENT
  }
  case object CUSTOMER extends zio.aws.connect.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantRole =
      software.amazon.awssdk.services.connect.model.ParticipantRole.CUSTOMER
  }
  case object SYSTEM extends zio.aws.connect.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantRole =
      software.amazon.awssdk.services.connect.model.ParticipantRole.SYSTEM
  }
  case object CUSTOM_BOT extends zio.aws.connect.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantRole =
      software.amazon.awssdk.services.connect.model.ParticipantRole.CUSTOM_BOT
  }
}
