package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ParticipantTimerConfiguration(
    participantRole: zio.aws.connect.model.TimerEligibleParticipantRoles,
    timerType: zio.aws.connect.model.ParticipantTimerType,
    timerValue: zio.aws.connect.model.ParticipantTimerValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ParticipantTimerConfiguration = {
    import ParticipantTimerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ParticipantTimerConfiguration
      .builder()
      .participantRole(participantRole.unwrap)
      .timerType(timerType.unwrap)
      .timerValue(timerValue.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ParticipantTimerConfiguration.ReadOnly =
    zio.aws.connect.model.ParticipantTimerConfiguration.wrap(buildAwsValue())
}
object ParticipantTimerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ParticipantTimerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ParticipantTimerConfiguration =
      zio.aws.connect.model.ParticipantTimerConfiguration(
        participantRole,
        timerType,
        timerValue.asEditable
      )
    def participantRole: zio.aws.connect.model.TimerEligibleParticipantRoles
    def timerType: zio.aws.connect.model.ParticipantTimerType
    def timerValue: zio.aws.connect.model.ParticipantTimerValue.ReadOnly
    def getParticipantRole: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.TimerEligibleParticipantRoles
    ] = ZIO.succeed(participantRole)
    def getTimerType
        : ZIO[Any, Nothing, zio.aws.connect.model.ParticipantTimerType] =
      ZIO.succeed(timerType)
    def getTimerValue: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.ParticipantTimerValue.ReadOnly
    ] = ZIO.succeed(timerValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ParticipantTimerConfiguration
  ) extends zio.aws.connect.model.ParticipantTimerConfiguration.ReadOnly {
    override val participantRole
        : zio.aws.connect.model.TimerEligibleParticipantRoles =
      zio.aws.connect.model.TimerEligibleParticipantRoles
        .wrap(impl.participantRole())
    override val timerType: zio.aws.connect.model.ParticipantTimerType =
      zio.aws.connect.model.ParticipantTimerType.wrap(impl.timerType())
    override val timerValue
        : zio.aws.connect.model.ParticipantTimerValue.ReadOnly =
      zio.aws.connect.model.ParticipantTimerValue.wrap(impl.timerValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ParticipantTimerConfiguration
  ): zio.aws.connect.model.ParticipantTimerConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
