package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ParticipantTimerType {
  def unwrap: software.amazon.awssdk.services.connect.model.ParticipantTimerType
}
object ParticipantTimerType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ParticipantTimerType
  ): zio.aws.connect.model.ParticipantTimerType = value match {
    case software.amazon.awssdk.services.connect.model.ParticipantTimerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ParticipantTimerType.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.connect.model.ParticipantTimerType.DISCONNECT_NONCUSTOMER =>
      val r = DISCONNECT_NONCUSTOMER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ParticipantTimerType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantTimerType =
      software.amazon.awssdk.services.connect.model.ParticipantTimerType.UNKNOWN_TO_SDK_VERSION
  }
  case object IDLE extends zio.aws.connect.model.ParticipantTimerType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantTimerType =
      software.amazon.awssdk.services.connect.model.ParticipantTimerType.IDLE
  }
  case object DISCONNECT_NONCUSTOMER
      extends zio.aws.connect.model.ParticipantTimerType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ParticipantTimerType =
      software.amazon.awssdk.services.connect.model.ParticipantTimerType.DISCONNECT_NONCUSTOMER
  }
}
