package zio.aws.connect.model
import zio.aws.connect.model.primitives.ParticipantTimerDurationInMinutes
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ParticipantTimerValue(
    participantTimerAction: Optional[
      zio.aws.connect.model.ParticipantTimerAction
    ] = Optional.Absent,
    participantTimerDurationInMinutes: Optional[
      ParticipantTimerDurationInMinutes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ParticipantTimerValue = {
    import ParticipantTimerValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ParticipantTimerValue
      .builder()
      .optionallyWith(participantTimerAction.map(value => value.unwrap))(
        _.participantTimerAction
      )
      .optionallyWith(
        participantTimerDurationInMinutes.map(value =>
          ParticipantTimerDurationInMinutes.unwrap(value): Integer
        )
      )(_.participantTimerDurationInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ParticipantTimerValue.ReadOnly =
    zio.aws.connect.model.ParticipantTimerValue.wrap(buildAwsValue())
}
object ParticipantTimerValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ParticipantTimerValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ParticipantTimerValue =
      zio.aws.connect.model.ParticipantTimerValue(
        participantTimerAction.map(value => value),
        participantTimerDurationInMinutes.map(value => value)
      )
    def participantTimerAction
        : Optional[zio.aws.connect.model.ParticipantTimerAction]
    def participantTimerDurationInMinutes
        : Optional[ParticipantTimerDurationInMinutes]
    def getParticipantTimerAction
        : ZIO[Any, AwsError, zio.aws.connect.model.ParticipantTimerAction] =
      AwsError.unwrapOptionField(
        "participantTimerAction",
        participantTimerAction
      )
    def getParticipantTimerDurationInMinutes
        : ZIO[Any, AwsError, ParticipantTimerDurationInMinutes] =
      AwsError.unwrapOptionField(
        "participantTimerDurationInMinutes",
        participantTimerDurationInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ParticipantTimerValue
  ) extends zio.aws.connect.model.ParticipantTimerValue.ReadOnly {
    override val participantTimerAction
        : Optional[zio.aws.connect.model.ParticipantTimerAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantTimerAction())
        .map(value => zio.aws.connect.model.ParticipantTimerAction.wrap(value))
    override val participantTimerDurationInMinutes
        : Optional[ParticipantTimerDurationInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.participantTimerDurationInMinutes())
      .map(value =>
        zio.aws.connect.model.primitives
          .ParticipantTimerDurationInMinutes(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ParticipantTimerValue
  ): zio.aws.connect.model.ParticipantTimerValue.ReadOnly = new Wrapper(impl)
}
