package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ISO8601Datetime, ParticipantToken}
import scala.jdk.CollectionConverters._
final case class ParticipantTokenCredentials(
    participantToken: Optional[ParticipantToken] = Optional.Absent,
    expiry: Optional[ISO8601Datetime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ParticipantTokenCredentials = {
    import ParticipantTokenCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ParticipantTokenCredentials
      .builder()
      .optionallyWith(
        participantToken.map(value =>
          ParticipantToken.unwrap(value): java.lang.String
        )
      )(_.participantToken)
      .optionallyWith(
        expiry.map(value => ISO8601Datetime.unwrap(value): java.lang.String)
      )(_.expiry)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ParticipantTokenCredentials.ReadOnly =
    zio.aws.connect.model.ParticipantTokenCredentials.wrap(buildAwsValue())
}
object ParticipantTokenCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ParticipantTokenCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ParticipantTokenCredentials =
      zio.aws.connect.model.ParticipantTokenCredentials(
        participantToken.map(value => value),
        expiry.map(value => value)
      )
    def participantToken: Optional[ParticipantToken]
    def expiry: Optional[ISO8601Datetime]
    def getParticipantToken: ZIO[Any, AwsError, ParticipantToken] =
      AwsError.unwrapOptionField("participantToken", participantToken)
    def getExpiry: ZIO[Any, AwsError, ISO8601Datetime] =
      AwsError.unwrapOptionField("expiry", expiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ParticipantTokenCredentials
  ) extends zio.aws.connect.model.ParticipantTokenCredentials.ReadOnly {
    override val participantToken: Optional[ParticipantToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantToken())
        .map(value => zio.aws.connect.model.primitives.ParticipantToken(value))
    override val expiry: Optional[ISO8601Datetime] = zio.aws.core.internal
      .optionalFromNullable(impl.expiry())
      .map(value => zio.aws.connect.model.primitives.ISO8601Datetime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ParticipantTokenCredentials
  ): zio.aws.connect.model.ParticipantTokenCredentials.ReadOnly = new Wrapper(
    impl
  )
}
