package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ContactId
import scala.jdk.CollectionConverters._
final case class PersistentChat(
    rehydrationType: Optional[zio.aws.connect.model.RehydrationType] =
      Optional.Absent,
    sourceContactId: Optional[ContactId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PersistentChat = {
    import PersistentChat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PersistentChat
      .builder()
      .optionallyWith(rehydrationType.map(value => value.unwrap))(
        _.rehydrationType
      )
      .optionallyWith(
        sourceContactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.sourceContactId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PersistentChat.ReadOnly =
    zio.aws.connect.model.PersistentChat.wrap(buildAwsValue())
}
object PersistentChat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PersistentChat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PersistentChat =
      zio.aws.connect.model.PersistentChat(
        rehydrationType.map(value => value),
        sourceContactId.map(value => value)
      )
    def rehydrationType: Optional[zio.aws.connect.model.RehydrationType]
    def sourceContactId: Optional[ContactId]
    def getRehydrationType
        : ZIO[Any, AwsError, zio.aws.connect.model.RehydrationType] =
      AwsError.unwrapOptionField("rehydrationType", rehydrationType)
    def getSourceContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("sourceContactId", sourceContactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PersistentChat
  ) extends zio.aws.connect.model.PersistentChat.ReadOnly {
    override val rehydrationType
        : Optional[zio.aws.connect.model.RehydrationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rehydrationType())
        .map(value => zio.aws.connect.model.RehydrationType.wrap(value))
    override val sourceContactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PersistentChat
  ): zio.aws.connect.model.PersistentChat.ReadOnly = new Wrapper(impl)
}
