package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.PhoneNumber
import scala.jdk.CollectionConverters._
final case class PhoneNumberQuickConnectConfig(phoneNumber: PhoneNumber) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PhoneNumberQuickConnectConfig = {
    import PhoneNumberQuickConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PhoneNumberQuickConnectConfig
      .builder()
      .phoneNumber(PhoneNumber.unwrap(phoneNumber): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly =
    zio.aws.connect.model.PhoneNumberQuickConnectConfig.wrap(buildAwsValue())
}
object PhoneNumberQuickConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PhoneNumberQuickConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PhoneNumberQuickConnectConfig =
      zio.aws.connect.model.PhoneNumberQuickConnectConfig(phoneNumber)
    def phoneNumber: PhoneNumber
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberQuickConnectConfig
  ) extends zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly {
    override val phoneNumber: PhoneNumber =
      zio.aws.connect.model.primitives.PhoneNumber(impl.phoneNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberQuickConnectConfig
  ): zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly = new Wrapper(
    impl
  )
}
