package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait PhoneType {
  def unwrap: software.amazon.awssdk.services.connect.model.PhoneType
}
object PhoneType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.PhoneType
  ): zio.aws.connect.model.PhoneType = value match {
    case software.amazon.awssdk.services.connect.model.PhoneType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.PhoneType.SOFT_PHONE =>
      val r = SOFT_PHONE
      r
    case software.amazon.awssdk.services.connect.model.PhoneType.DESK_PHONE =>
      val r = DESK_PHONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.PhoneType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.PhoneType =
      software.amazon.awssdk.services.connect.model.PhoneType.UNKNOWN_TO_SDK_VERSION
  }
  case object SOFT_PHONE extends zio.aws.connect.model.PhoneType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.PhoneType =
      software.amazon.awssdk.services.connect.model.PhoneType.SOFT_PHONE
  }
  case object DESK_PHONE extends zio.aws.connect.model.PhoneType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.PhoneType =
      software.amazon.awssdk.services.connect.model.PhoneType.DESK_PHONE
  }
}
