package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TagValue,
  CommonNameLength127,
  PromptDescription,
  ARN,
  TagKey,
  PromptId
}
import scala.jdk.CollectionConverters._
final case class Prompt(
    promptARN: Optional[ARN] = Optional.Absent,
    promptId: Optional[PromptId] = Optional.Absent,
    name: Optional[CommonNameLength127] = Optional.Absent,
    description: Optional[PromptDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Prompt = {
    import Prompt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Prompt
      .builder()
      .optionallyWith(
        promptARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.promptARN)
      .optionallyWith(
        promptId.map(value => PromptId.unwrap(value): java.lang.String)
      )(_.promptId)
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          PromptDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Prompt.ReadOnly =
    zio.aws.connect.model.Prompt.wrap(buildAwsValue())
}
object Prompt {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Prompt] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Prompt = zio.aws.connect.model.Prompt(
      promptARN.map(value => value),
      promptId.map(value => value),
      name.map(value => value),
      description.map(value => value),
      tags.map(value => value)
    )
    def promptARN: Optional[ARN]
    def promptId: Optional[PromptId]
    def name: Optional[CommonNameLength127]
    def description: Optional[PromptDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getPromptARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("promptARN", promptARN)
    def getPromptId: ZIO[Any, AwsError, PromptId] =
      AwsError.unwrapOptionField("promptId", promptId)
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, PromptDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Prompt
  ) extends zio.aws.connect.model.Prompt.ReadOnly {
    override val promptARN: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.promptARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val promptId: Optional[PromptId] = zio.aws.core.internal
      .optionalFromNullable(impl.promptId())
      .map(value => zio.aws.connect.model.primitives.PromptId(value))
    override val name: Optional[CommonNameLength127] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val description: Optional[PromptDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.connect.model.primitives.PromptDescription(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Prompt
  ): zio.aws.connect.model.Prompt.ReadOnly = new Wrapper(impl)
}
