package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PromptSearchCriteria(
    orConditions: Optional[
      Iterable[zio.aws.connect.model.PromptSearchCriteria]
    ] = Optional.Absent,
    andConditions: Optional[
      Iterable[zio.aws.connect.model.PromptSearchCriteria]
    ] = Optional.Absent,
    stringCondition: Optional[zio.aws.connect.model.StringCondition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PromptSearchCriteria = {
    import PromptSearchCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PromptSearchCriteria
      .builder()
      .optionallyWith(
        orConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orConditions)
      .optionallyWith(
        andConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andConditions)
      .optionallyWith(stringCondition.map(value => value.buildAwsValue()))(
        _.stringCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PromptSearchCriteria.ReadOnly =
    zio.aws.connect.model.PromptSearchCriteria.wrap(buildAwsValue())
}
object PromptSearchCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PromptSearchCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PromptSearchCriteria =
      zio.aws.connect.model.PromptSearchCriteria(
        orConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        andConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringCondition.map(value => value.asEditable)
      )
    def orConditions
        : Optional[List[zio.aws.connect.model.PromptSearchCriteria.ReadOnly]]
    def andConditions
        : Optional[List[zio.aws.connect.model.PromptSearchCriteria.ReadOnly]]
    def stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly]
    def getOrConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.PromptSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("orConditions", orConditions)
    def getAndConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.PromptSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("andConditions", andConditions)
    def getStringCondition
        : ZIO[Any, AwsError, zio.aws.connect.model.StringCondition.ReadOnly] =
      AwsError.unwrapOptionField("stringCondition", stringCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PromptSearchCriteria
  ) extends zio.aws.connect.model.PromptSearchCriteria.ReadOnly {
    override val orConditions
        : Optional[List[zio.aws.connect.model.PromptSearchCriteria.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PromptSearchCriteria.wrap(item)
          }.toList
        )
    override val andConditions
        : Optional[List[zio.aws.connect.model.PromptSearchCriteria.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PromptSearchCriteria.wrap(item)
          }.toList
        )
    override val stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringCondition())
        .map(value => zio.aws.connect.model.StringCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PromptSearchCriteria
  ): zio.aws.connect.model.PromptSearchCriteria.ReadOnly = new Wrapper(impl)
}
