package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PromptSearchFilter(
    tagFilter: Optional[zio.aws.connect.model.ControlPlaneTagFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PromptSearchFilter = {
    import PromptSearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PromptSearchFilter
      .builder()
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PromptSearchFilter.ReadOnly =
    zio.aws.connect.model.PromptSearchFilter.wrap(buildAwsValue())
}
object PromptSearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PromptSearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PromptSearchFilter =
      zio.aws.connect.model
        .PromptSearchFilter(tagFilter.map(value => value.asEditable))
    def tagFilter
        : Optional[zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly]
    def getTagFilter: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly
    ] = AwsError.unwrapOptionField("tagFilter", tagFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PromptSearchFilter
  ) extends zio.aws.connect.model.PromptSearchFilter.ReadOnly {
    override val tagFilter
        : Optional[zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilter())
        .map(value => zio.aws.connect.model.ControlPlaneTagFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PromptSearchFilter
  ): zio.aws.connect.model.PromptSearchFilter.ReadOnly = new Wrapper(impl)
}
