package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  QueueId,
  HoursOfOperationId,
  TagValue,
  QueueMaxContacts,
  CommonNameLength127,
  QueueDescription,
  ARN,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Queue(
    name: Optional[CommonNameLength127] = Optional.Absent,
    queueArn: Optional[ARN] = Optional.Absent,
    queueId: Optional[QueueId] = Optional.Absent,
    description: Optional[QueueDescription] = Optional.Absent,
    outboundCallerConfig: Optional[zio.aws.connect.model.OutboundCallerConfig] =
      Optional.Absent,
    hoursOfOperationId: Optional[HoursOfOperationId] = Optional.Absent,
    maxContacts: Optional[QueueMaxContacts] = Optional.Absent,
    status: Optional[zio.aws.connect.model.QueueStatus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Queue = {
    import Queue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Queue
      .builder()
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        queueArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.queueArn)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        description.map(value =>
          QueueDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(outboundCallerConfig.map(value => value.buildAwsValue()))(
        _.outboundCallerConfig
      )
      .optionallyWith(
        hoursOfOperationId.map(value =>
          HoursOfOperationId.unwrap(value): java.lang.String
        )
      )(_.hoursOfOperationId)
      .optionallyWith(
        maxContacts.map(value => QueueMaxContacts.unwrap(value): Integer)
      )(_.maxContacts)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Queue.ReadOnly =
    zio.aws.connect.model.Queue.wrap(buildAwsValue())
}
object Queue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Queue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Queue = zio.aws.connect.model.Queue(
      name.map(value => value),
      queueArn.map(value => value),
      queueId.map(value => value),
      description.map(value => value),
      outboundCallerConfig.map(value => value.asEditable),
      hoursOfOperationId.map(value => value),
      maxContacts.map(value => value),
      status.map(value => value),
      tags.map(value => value)
    )
    def name: Optional[CommonNameLength127]
    def queueArn: Optional[ARN]
    def queueId: Optional[QueueId]
    def description: Optional[QueueDescription]
    def outboundCallerConfig
        : Optional[zio.aws.connect.model.OutboundCallerConfig.ReadOnly]
    def hoursOfOperationId: Optional[HoursOfOperationId]
    def maxContacts: Optional[QueueMaxContacts]
    def status: Optional[zio.aws.connect.model.QueueStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getQueueArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("queueArn", queueArn)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getDescription: ZIO[Any, AwsError, QueueDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOutboundCallerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.OutboundCallerConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outboundCallerConfig", outboundCallerConfig)
    def getHoursOfOperationId: ZIO[Any, AwsError, HoursOfOperationId] =
      AwsError.unwrapOptionField("hoursOfOperationId", hoursOfOperationId)
    def getMaxContacts: ZIO[Any, AwsError, QueueMaxContacts] =
      AwsError.unwrapOptionField("maxContacts", maxContacts)
    def getStatus: ZIO[Any, AwsError, zio.aws.connect.model.QueueStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Queue
  ) extends zio.aws.connect.model.Queue.ReadOnly {
    override val name: Optional[CommonNameLength127] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val queueArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.queueArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val description: Optional[QueueDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.QueueDescription(value))
    override val outboundCallerConfig
        : Optional[zio.aws.connect.model.OutboundCallerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outboundCallerConfig())
        .map(value => zio.aws.connect.model.OutboundCallerConfig.wrap(value))
    override val hoursOfOperationId: Optional[HoursOfOperationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hoursOfOperationId())
        .map(value =>
          zio.aws.connect.model.primitives.HoursOfOperationId(value)
        )
    override val maxContacts: Optional[QueueMaxContacts] = zio.aws.core.internal
      .optionalFromNullable(impl.maxContacts())
      .map(value => zio.aws.connect.model.primitives.QueueMaxContacts(value))
    override val status: Optional[zio.aws.connect.model.QueueStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.QueueStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Queue
  ): zio.aws.connect.model.Queue.ReadOnly = new Wrapper(impl)
}
