package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait QueueStatus {
  def unwrap: software.amazon.awssdk.services.connect.model.QueueStatus
}
object QueueStatus {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.QueueStatus
  ): zio.aws.connect.model.QueueStatus = value match {
    case software.amazon.awssdk.services.connect.model.QueueStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.QueueStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.connect.model.QueueStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QueueStatus =
      software.amazon.awssdk.services.connect.model.QueueStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.connect.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QueueStatus =
      software.amazon.awssdk.services.connect.model.QueueStatus.ENABLED
  }
  case object DISABLED extends zio.aws.connect.model.QueueStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QueueStatus =
      software.amazon.awssdk.services.connect.model.QueueStatus.DISABLED
  }
}
