package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  QuickConnectId,
  TagValue,
  QuickConnectName,
  QuickConnectDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class QuickConnect(
    quickConnectARN: Optional[ARN] = Optional.Absent,
    quickConnectId: Optional[QuickConnectId] = Optional.Absent,
    name: Optional[QuickConnectName] = Optional.Absent,
    description: Optional[QuickConnectDescription] = Optional.Absent,
    quickConnectConfig: Optional[zio.aws.connect.model.QuickConnectConfig] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnect = {
    import QuickConnect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnect
      .builder()
      .optionallyWith(
        quickConnectARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.quickConnectARN)
      .optionallyWith(
        quickConnectId.map(value =>
          QuickConnectId.unwrap(value): java.lang.String
        )
      )(_.quickConnectId)
      .optionallyWith(
        name.map(value => QuickConnectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          QuickConnectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(quickConnectConfig.map(value => value.buildAwsValue()))(
        _.quickConnectConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnect.ReadOnly =
    zio.aws.connect.model.QuickConnect.wrap(buildAwsValue())
}
object QuickConnect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnect =
      zio.aws.connect.model.QuickConnect(
        quickConnectARN.map(value => value),
        quickConnectId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        quickConnectConfig.map(value => value.asEditable),
        tags.map(value => value)
      )
    def quickConnectARN: Optional[ARN]
    def quickConnectId: Optional[QuickConnectId]
    def name: Optional[QuickConnectName]
    def description: Optional[QuickConnectDescription]
    def quickConnectConfig
        : Optional[zio.aws.connect.model.QuickConnectConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getQuickConnectARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("quickConnectARN", quickConnectARN)
    def getQuickConnectId: ZIO[Any, AwsError, QuickConnectId] =
      AwsError.unwrapOptionField("quickConnectId", quickConnectId)
    def getName: ZIO[Any, AwsError, QuickConnectName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, QuickConnectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQuickConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.QuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("quickConnectConfig", quickConnectConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnect
  ) extends zio.aws.connect.model.QuickConnect.ReadOnly {
    override val quickConnectARN: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.quickConnectARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val quickConnectId: Optional[QuickConnectId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectId())
        .map(value => zio.aws.connect.model.primitives.QuickConnectId(value))
    override val name: Optional[QuickConnectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.QuickConnectName(value))
    override val description: Optional[QuickConnectDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.QuickConnectDescription(value)
        )
    override val quickConnectConfig
        : Optional[zio.aws.connect.model.QuickConnectConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectConfig())
        .map(value => zio.aws.connect.model.QuickConnectConfig.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnect
  ): zio.aws.connect.model.QuickConnect.ReadOnly = new Wrapper(impl)
}
