package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QuickConnectConfig(
    quickConnectType: zio.aws.connect.model.QuickConnectType,
    userConfig: Optional[zio.aws.connect.model.UserQuickConnectConfig] =
      Optional.Absent,
    queueConfig: Optional[zio.aws.connect.model.QueueQuickConnectConfig] =
      Optional.Absent,
    phoneConfig: Optional[zio.aws.connect.model.PhoneNumberQuickConnectConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnectConfig = {
    import QuickConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnectConfig
      .builder()
      .quickConnectType(quickConnectType.unwrap)
      .optionallyWith(userConfig.map(value => value.buildAwsValue()))(
        _.userConfig
      )
      .optionallyWith(queueConfig.map(value => value.buildAwsValue()))(
        _.queueConfig
      )
      .optionallyWith(phoneConfig.map(value => value.buildAwsValue()))(
        _.phoneConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnectConfig.ReadOnly =
    zio.aws.connect.model.QuickConnectConfig.wrap(buildAwsValue())
}
object QuickConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnectConfig =
      zio.aws.connect.model.QuickConnectConfig(
        quickConnectType,
        userConfig.map(value => value.asEditable),
        queueConfig.map(value => value.asEditable),
        phoneConfig.map(value => value.asEditable)
      )
    def quickConnectType: zio.aws.connect.model.QuickConnectType
    def userConfig
        : Optional[zio.aws.connect.model.UserQuickConnectConfig.ReadOnly]
    def queueConfig
        : Optional[zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly]
    def phoneConfig
        : Optional[zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly]
    def getQuickConnectType
        : ZIO[Any, Nothing, zio.aws.connect.model.QuickConnectType] =
      ZIO.succeed(quickConnectType)
    def getUserConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.UserQuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("userConfig", userConfig)
    def getQueueConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("queueConfig", queueConfig)
    def getPhoneConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("phoneConfig", phoneConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectConfig
  ) extends zio.aws.connect.model.QuickConnectConfig.ReadOnly {
    override val quickConnectType: zio.aws.connect.model.QuickConnectType =
      zio.aws.connect.model.QuickConnectType.wrap(impl.quickConnectType())
    override val userConfig
        : Optional[zio.aws.connect.model.UserQuickConnectConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userConfig())
        .map(value => zio.aws.connect.model.UserQuickConnectConfig.wrap(value))
    override val queueConfig
        : Optional[zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueConfig())
        .map(value => zio.aws.connect.model.QueueQuickConnectConfig.wrap(value))
    override val phoneConfig: Optional[
      zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneConfig())
      .map(value =>
        zio.aws.connect.model.PhoneNumberQuickConnectConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectConfig
  ): zio.aws.connect.model.QuickConnectConfig.ReadOnly = new Wrapper(impl)
}
