package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QuickConnectSearchFilter(
    tagFilter: Optional[zio.aws.connect.model.ControlPlaneTagFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnectSearchFilter = {
    import QuickConnectSearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnectSearchFilter
      .builder()
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnectSearchFilter.ReadOnly =
    zio.aws.connect.model.QuickConnectSearchFilter.wrap(buildAwsValue())
}
object QuickConnectSearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnectSearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnectSearchFilter =
      zio.aws.connect.model
        .QuickConnectSearchFilter(tagFilter.map(value => value.asEditable))
    def tagFilter
        : Optional[zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly]
    def getTagFilter: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly
    ] = AwsError.unwrapOptionField("tagFilter", tagFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectSearchFilter
  ) extends zio.aws.connect.model.QuickConnectSearchFilter.ReadOnly {
    override val tagFilter
        : Optional[zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilter())
        .map(value => zio.aws.connect.model.ControlPlaneTagFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectSearchFilter
  ): zio.aws.connect.model.QuickConnectSearchFilter.ReadOnly = new Wrapper(impl)
}
