package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{QuickConnectName, ARN, QuickConnectId}
import scala.jdk.CollectionConverters._
final case class QuickConnectSummary(
    id: Optional[QuickConnectId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[QuickConnectName] = Optional.Absent,
    quickConnectType: Optional[zio.aws.connect.model.QuickConnectType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnectSummary = {
    import QuickConnectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnectSummary
      .builder()
      .optionallyWith(
        id.map(value => QuickConnectId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => QuickConnectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(quickConnectType.map(value => value.unwrap))(
        _.quickConnectType
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnectSummary.ReadOnly =
    zio.aws.connect.model.QuickConnectSummary.wrap(buildAwsValue())
}
object QuickConnectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnectSummary =
      zio.aws.connect.model.QuickConnectSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        quickConnectType.map(value => value)
      )
    def id: Optional[QuickConnectId]
    def arn: Optional[ARN]
    def name: Optional[QuickConnectName]
    def quickConnectType: Optional[zio.aws.connect.model.QuickConnectType]
    def getId: ZIO[Any, AwsError, QuickConnectId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, QuickConnectName] =
      AwsError.unwrapOptionField("name", name)
    def getQuickConnectType
        : ZIO[Any, AwsError, zio.aws.connect.model.QuickConnectType] =
      AwsError.unwrapOptionField("quickConnectType", quickConnectType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectSummary
  ) extends zio.aws.connect.model.QuickConnectSummary.ReadOnly {
    override val id: Optional[QuickConnectId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.QuickConnectId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[QuickConnectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.QuickConnectName(value))
    override val quickConnectType
        : Optional[zio.aws.connect.model.QuickConnectType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectType())
        .map(value => zio.aws.connect.model.QuickConnectType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectSummary
  ): zio.aws.connect.model.QuickConnectSummary.ReadOnly = new Wrapper(impl)
}
