package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ReferenceStatus {
  def unwrap: software.amazon.awssdk.services.connect.model.ReferenceStatus
}
object ReferenceStatus {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ReferenceStatus
  ): zio.aws.connect.model.ReferenceStatus = value match {
    case software.amazon.awssdk.services.connect.model.ReferenceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ReferenceStatus.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.connect.model.ReferenceStatus.REJECTED =>
      val r = REJECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceStatus =
      software.amazon.awssdk.services.connect.model.ReferenceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVED extends zio.aws.connect.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceStatus =
      software.amazon.awssdk.services.connect.model.ReferenceStatus.APPROVED
  }
  case object REJECTED extends zio.aws.connect.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceStatus =
      software.amazon.awssdk.services.connect.model.ReferenceStatus.REJECTED
  }
}
