package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ReferenceType {
  def unwrap: software.amazon.awssdk.services.connect.model.ReferenceType
}
object ReferenceType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ReferenceType
  ): zio.aws.connect.model.ReferenceType = value match {
    case software.amazon.awssdk.services.connect.model.ReferenceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ReferenceType.URL =>
      val r = URL
      r
    case software.amazon.awssdk.services.connect.model.ReferenceType.ATTACHMENT =>
      val r = ATTACHMENT
      r
    case software.amazon.awssdk.services.connect.model.ReferenceType.NUMBER =>
      val r = NUMBER
      r
    case software.amazon.awssdk.services.connect.model.ReferenceType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.connect.model.ReferenceType.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.connect.model.ReferenceType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.UNKNOWN_TO_SDK_VERSION
  }
  case object URL extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.URL
  }
  case object ATTACHMENT extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.ATTACHMENT
  }
  case object NUMBER extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.NUMBER
  }
  case object STRING extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.STRING
  }
  case object DATE extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.DATE
  }
  case object EMAIL extends zio.aws.connect.model.ReferenceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ReferenceType =
      software.amazon.awssdk.services.connect.model.ReferenceType.EMAIL
  }
}
