package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait RehydrationType {
  def unwrap: software.amazon.awssdk.services.connect.model.RehydrationType
}
object RehydrationType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.RehydrationType
  ): zio.aws.connect.model.RehydrationType = value match {
    case software.amazon.awssdk.services.connect.model.RehydrationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.RehydrationType.ENTIRE_PAST_SESSION =>
      val r = ENTIRE_PAST_SESSION
      r
    case software.amazon.awssdk.services.connect.model.RehydrationType.FROM_SEGMENT =>
      val r = FROM_SEGMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.RehydrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.RehydrationType =
      software.amazon.awssdk.services.connect.model.RehydrationType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENTIRE_PAST_SESSION
      extends zio.aws.connect.model.RehydrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.RehydrationType =
      software.amazon.awssdk.services.connect.model.RehydrationType.ENTIRE_PAST_SESSION
  }
  case object FROM_SEGMENT extends zio.aws.connect.model.RehydrationType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.RehydrationType =
      software.amazon.awssdk.services.connect.model.RehydrationType.FROM_SEGMENT
  }
}
