package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  DirectoryAlias,
  ClientToken,
  AwsRegion,
  InstanceIdOrArn
}
import scala.jdk.CollectionConverters._
final case class ReplicateInstanceRequest(
    instanceId: InstanceIdOrArn,
    replicaRegion: AwsRegion,
    clientToken: Optional[ClientToken] = Optional.Absent,
    replicaAlias: DirectoryAlias
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest = {
    import ReplicateInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest
      .builder()
      .instanceId(InstanceIdOrArn.unwrap(instanceId): java.lang.String)
      .replicaRegion(AwsRegion.unwrap(replicaRegion): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .replicaAlias(DirectoryAlias.unwrap(replicaAlias): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ReplicateInstanceRequest.ReadOnly =
    zio.aws.connect.model.ReplicateInstanceRequest.wrap(buildAwsValue())
}
object ReplicateInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ReplicateInstanceRequest =
      zio.aws.connect.model.ReplicateInstanceRequest(
        instanceId,
        replicaRegion,
        clientToken.map(value => value),
        replicaAlias
      )
    def instanceId: InstanceIdOrArn
    def replicaRegion: AwsRegion
    def clientToken: Optional[ClientToken]
    def replicaAlias: DirectoryAlias
    def getInstanceId: ZIO[Any, Nothing, InstanceIdOrArn] =
      ZIO.succeed(instanceId)
    def getReplicaRegion: ZIO[Any, Nothing, AwsRegion] =
      ZIO.succeed(replicaRegion)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getReplicaAlias: ZIO[Any, Nothing, DirectoryAlias] =
      ZIO.succeed(replicaAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest
  ) extends zio.aws.connect.model.ReplicateInstanceRequest.ReadOnly {
    override val instanceId: InstanceIdOrArn =
      zio.aws.connect.model.primitives.InstanceIdOrArn(impl.instanceId())
    override val replicaRegion: AwsRegion =
      zio.aws.connect.model.primitives.AwsRegion(impl.replicaRegion())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val replicaAlias: DirectoryAlias =
      zio.aws.connect.model.primitives.DirectoryAlias(impl.replicaAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest
  ): zio.aws.connect.model.ReplicateInstanceRequest.ReadOnly = new Wrapper(impl)
}
