package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, InstanceId}
import scala.jdk.CollectionConverters._
final case class ReplicateInstanceResponse(
    id: Optional[InstanceId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse = {
    import ReplicateInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse
      .builder()
      .optionallyWith(
        id.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly =
    zio.aws.connect.model.ReplicateInstanceResponse.wrap(buildAwsValue())
}
object ReplicateInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ReplicateInstanceResponse =
      zio.aws.connect.model.ReplicateInstanceResponse(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[InstanceId]
    def arn: Optional[ARN]
    def getId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse
  ) extends zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly {
    override val id: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse
  ): zio.aws.connect.model.ReplicateInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
