package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceTagsSearchCriteria(
    tagSearchCondition: Optional[zio.aws.connect.model.TagSearchCondition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ResourceTagsSearchCriteria = {
    import ResourceTagsSearchCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ResourceTagsSearchCriteria
      .builder()
      .optionallyWith(tagSearchCondition.map(value => value.buildAwsValue()))(
        _.tagSearchCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ResourceTagsSearchCriteria.ReadOnly =
    zio.aws.connect.model.ResourceTagsSearchCriteria.wrap(buildAwsValue())
}
object ResourceTagsSearchCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ResourceTagsSearchCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ResourceTagsSearchCriteria =
      zio.aws.connect.model.ResourceTagsSearchCriteria(
        tagSearchCondition.map(value => value.asEditable)
      )
    def tagSearchCondition
        : Optional[zio.aws.connect.model.TagSearchCondition.ReadOnly]
    def getTagSearchCondition: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TagSearchCondition.ReadOnly
    ] = AwsError.unwrapOptionField("tagSearchCondition", tagSearchCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ResourceTagsSearchCriteria
  ) extends zio.aws.connect.model.ResourceTagsSearchCriteria.ReadOnly {
    override val tagSearchCondition
        : Optional[zio.aws.connect.model.TagSearchCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSearchCondition())
        .map(value => zio.aws.connect.model.TagSearchCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ResourceTagsSearchCriteria
  ): zio.aws.connect.model.ResourceTagsSearchCriteria.ReadOnly = new Wrapper(
    impl
  )
}
