package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class ResumeContactRecordingRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    initialContactId: ContactId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest = {
    import ResumeContactRecordingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .initialContactId(ContactId.unwrap(initialContactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ResumeContactRecordingRequest.ReadOnly =
    zio.aws.connect.model.ResumeContactRecordingRequest.wrap(buildAwsValue())
}
object ResumeContactRecordingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ResumeContactRecordingRequest =
      zio.aws.connect.model
        .ResumeContactRecordingRequest(instanceId, contactId, initialContactId)
    def instanceId: InstanceId
    def contactId: ContactId
    def initialContactId: ContactId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getInitialContactId: ZIO[Any, Nothing, ContactId] =
      ZIO.succeed(initialContactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest
  ) extends zio.aws.connect.model.ResumeContactRecordingRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val initialContactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.initialContactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest
  ): zio.aws.connect.model.ResumeContactRecordingRequest.ReadOnly = new Wrapper(
    impl
  )
}
