package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  RoutingProfileId,
  QueueId,
  InstanceId,
  TagValue,
  RoutingProfileName,
  RoutingProfileDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class RoutingProfile(
    instanceId: Optional[InstanceId] = Optional.Absent,
    name: Optional[RoutingProfileName] = Optional.Absent,
    routingProfileArn: Optional[ARN] = Optional.Absent,
    routingProfileId: Optional[RoutingProfileId] = Optional.Absent,
    description: Optional[RoutingProfileDescription] = Optional.Absent,
    mediaConcurrencies: Optional[
      Iterable[zio.aws.connect.model.MediaConcurrency]
    ] = Optional.Absent,
    defaultOutboundQueueId: Optional[QueueId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    numberOfAssociatedQueues: Optional[Long] = Optional.Absent,
    numberOfAssociatedUsers: Optional[Long] = Optional.Absent,
    agentAvailabilityTimer: Optional[
      zio.aws.connect.model.AgentAvailabilityTimer
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfile = {
    import RoutingProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfile
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        name.map(value => RoutingProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        routingProfileArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.routingProfileArn)
      .optionallyWith(
        routingProfileId.map(value =>
          RoutingProfileId.unwrap(value): java.lang.String
        )
      )(_.routingProfileId)
      .optionallyWith(
        description.map(value =>
          RoutingProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        mediaConcurrencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaConcurrencies)
      .optionallyWith(
        defaultOutboundQueueId.map(value =>
          QueueId.unwrap(value): java.lang.String
        )
      )(_.defaultOutboundQueueId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        numberOfAssociatedQueues.map(value => value: java.lang.Long)
      )(_.numberOfAssociatedQueues)
      .optionallyWith(
        numberOfAssociatedUsers.map(value => value: java.lang.Long)
      )(_.numberOfAssociatedUsers)
      .optionallyWith(agentAvailabilityTimer.map(value => value.unwrap))(
        _.agentAvailabilityTimer
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RoutingProfile.ReadOnly =
    zio.aws.connect.model.RoutingProfile.wrap(buildAwsValue())
}
object RoutingProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfile =
      zio.aws.connect.model.RoutingProfile(
        instanceId.map(value => value),
        name.map(value => value),
        routingProfileArn.map(value => value),
        routingProfileId.map(value => value),
        description.map(value => value),
        mediaConcurrencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultOutboundQueueId.map(value => value),
        tags.map(value => value),
        numberOfAssociatedQueues.map(value => value),
        numberOfAssociatedUsers.map(value => value),
        agentAvailabilityTimer.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def name: Optional[RoutingProfileName]
    def routingProfileArn: Optional[ARN]
    def routingProfileId: Optional[RoutingProfileId]
    def description: Optional[RoutingProfileDescription]
    def mediaConcurrencies
        : Optional[List[zio.aws.connect.model.MediaConcurrency.ReadOnly]]
    def defaultOutboundQueueId: Optional[QueueId]
    def tags: Optional[Map[TagKey, TagValue]]
    def numberOfAssociatedQueues: Optional[Long]
    def numberOfAssociatedUsers: Optional[Long]
    def agentAvailabilityTimer
        : Optional[zio.aws.connect.model.AgentAvailabilityTimer]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getName: ZIO[Any, AwsError, RoutingProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getRoutingProfileArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("routingProfileArn", routingProfileArn)
    def getRoutingProfileId: ZIO[Any, AwsError, RoutingProfileId] =
      AwsError.unwrapOptionField("routingProfileId", routingProfileId)
    def getDescription: ZIO[Any, AwsError, RoutingProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getMediaConcurrencies: ZIO[Any, AwsError, List[
      zio.aws.connect.model.MediaConcurrency.ReadOnly
    ]] = AwsError.unwrapOptionField("mediaConcurrencies", mediaConcurrencies)
    def getDefaultOutboundQueueId: ZIO[Any, AwsError, QueueId] = AwsError
      .unwrapOptionField("defaultOutboundQueueId", defaultOutboundQueueId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNumberOfAssociatedQueues: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("numberOfAssociatedQueues", numberOfAssociatedQueues)
    def getNumberOfAssociatedUsers: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("numberOfAssociatedUsers", numberOfAssociatedUsers)
    def getAgentAvailabilityTimer
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentAvailabilityTimer] =
      AwsError.unwrapOptionField(
        "agentAvailabilityTimer",
        agentAvailabilityTimer
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfile
  ) extends zio.aws.connect.model.RoutingProfile.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val name: Optional[RoutingProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileName(value))
    override val routingProfileArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.routingProfileArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val routingProfileId: Optional[RoutingProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfileId())
        .map(value => zio.aws.connect.model.primitives.RoutingProfileId(value))
    override val description: Optional[RoutingProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.RoutingProfileDescription(value)
        )
    override val mediaConcurrencies
        : Optional[List[zio.aws.connect.model.MediaConcurrency.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaConcurrencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.MediaConcurrency.wrap(item)
          }.toList
        )
    override val defaultOutboundQueueId: Optional[QueueId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultOutboundQueueId())
        .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val numberOfAssociatedQueues: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssociatedQueues())
        .map(value => value: Long)
    override val numberOfAssociatedUsers: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfAssociatedUsers())
      .map(value => value: Long)
    override val agentAvailabilityTimer
        : Optional[zio.aws.connect.model.AgentAvailabilityTimer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentAvailabilityTimer())
        .map(value => zio.aws.connect.model.AgentAvailabilityTimer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfile
  ): zio.aws.connect.model.RoutingProfile.ReadOnly = new Wrapper(impl)
}
