package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{Delay, Priority}
import scala.jdk.CollectionConverters._
final case class RoutingProfileQueueConfig(
    queueReference: zio.aws.connect.model.RoutingProfileQueueReference,
    priority: Priority,
    delay: Delay
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig = {
    import RoutingProfileQueueConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig
      .builder()
      .queueReference(queueReference.buildAwsValue())
      .priority(Priority.unwrap(priority): Integer)
      .delay(Delay.unwrap(delay): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly =
    zio.aws.connect.model.RoutingProfileQueueConfig.wrap(buildAwsValue())
}
object RoutingProfileQueueConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfileQueueConfig =
      zio.aws.connect.model
        .RoutingProfileQueueConfig(queueReference.asEditable, priority, delay)
    def queueReference
        : zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly
    def priority: Priority
    def delay: Delay
    def getQueueReference: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly
    ] = ZIO.succeed(queueReference)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getDelay: ZIO[Any, Nothing, Delay] = ZIO.succeed(delay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig
  ) extends zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly {
    override val queueReference
        : zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly =
      zio.aws.connect.model.RoutingProfileQueueReference
        .wrap(impl.queueReference())
    override val priority: Priority =
      zio.aws.connect.model.primitives.Priority(impl.priority())
    override val delay: Delay =
      zio.aws.connect.model.primitives.Delay(impl.delay())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig
  ): zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly = new Wrapper(
    impl
  )
}
