package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.QueueId
import scala.jdk.CollectionConverters._
final case class RoutingProfileQueueReference(
    queueId: QueueId,
    channel: zio.aws.connect.model.Channel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfileQueueReference = {
    import RoutingProfileQueueReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfileQueueReference
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .channel(channel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly =
    zio.aws.connect.model.RoutingProfileQueueReference.wrap(buildAwsValue())
}
object RoutingProfileQueueReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfileQueueReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfileQueueReference =
      zio.aws.connect.model.RoutingProfileQueueReference(queueId, channel)
    def queueId: QueueId
    def channel: zio.aws.connect.model.Channel
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getChannel: ZIO[Any, Nothing, zio.aws.connect.model.Channel] =
      ZIO.succeed(channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileQueueReference
  ) extends zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly {
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val channel: zio.aws.connect.model.Channel =
      zio.aws.connect.model.Channel.wrap(impl.channel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfileQueueReference
  ): zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly = new Wrapper(
    impl
  )
}
