package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  TagValue,
  RuleId,
  RuleName,
  RuleFunction,
  ARN,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Rule(
    name: RuleName,
    ruleId: RuleId,
    ruleArn: ARN,
    triggerEventSource: zio.aws.connect.model.RuleTriggerEventSource,
    function: RuleFunction,
    actions: Iterable[zio.aws.connect.model.RuleAction],
    publishStatus: zio.aws.connect.model.RulePublishStatus,
    createdTime: Timestamp,
    lastUpdatedTime: Timestamp,
    lastUpdatedBy: ARN,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Rule
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .ruleArn(ARN.unwrap(ruleArn): java.lang.String)
      .triggerEventSource(triggerEventSource.buildAwsValue())
      .function(RuleFunction.unwrap(function): java.lang.String)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .publishStatus(publishStatus.unwrap)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .lastUpdatedBy(ARN.unwrap(lastUpdatedBy): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Rule.ReadOnly =
    zio.aws.connect.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Rule = zio.aws.connect.model.Rule(
      name,
      ruleId,
      ruleArn,
      triggerEventSource.asEditable,
      function,
      actions.map { item =>
        item.asEditable
      },
      publishStatus,
      createdTime,
      lastUpdatedTime,
      lastUpdatedBy,
      tags.map(value => value)
    )
    def name: RuleName
    def ruleId: RuleId
    def ruleArn: ARN
    def triggerEventSource
        : zio.aws.connect.model.RuleTriggerEventSource.ReadOnly
    def function: RuleFunction
    def actions: List[zio.aws.connect.model.RuleAction.ReadOnly]
    def publishStatus: zio.aws.connect.model.RulePublishStatus
    def createdTime: Timestamp
    def lastUpdatedTime: Timestamp
    def lastUpdatedBy: ARN
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
    def getRuleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(ruleArn)
    def getTriggerEventSource: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.RuleTriggerEventSource.ReadOnly
    ] = ZIO.succeed(triggerEventSource)
    def getFunction: ZIO[Any, Nothing, RuleFunction] = ZIO.succeed(function)
    def getActions
        : ZIO[Any, Nothing, List[zio.aws.connect.model.RuleAction.ReadOnly]] =
      ZIO.succeed(actions)
    def getPublishStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.RulePublishStatus] =
      ZIO.succeed(publishStatus)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getLastUpdatedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Rule
  ) extends zio.aws.connect.model.Rule.ReadOnly {
    override val name: RuleName =
      zio.aws.connect.model.primitives.RuleName(impl.name())
    override val ruleId: RuleId =
      zio.aws.connect.model.primitives.RuleId(impl.ruleId())
    override val ruleArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.ruleArn())
    override val triggerEventSource
        : zio.aws.connect.model.RuleTriggerEventSource.ReadOnly =
      zio.aws.connect.model.RuleTriggerEventSource
        .wrap(impl.triggerEventSource())
    override val function: RuleFunction =
      zio.aws.connect.model.primitives.RuleFunction(impl.function())
    override val actions: List[zio.aws.connect.model.RuleAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.connect.model.RuleAction.wrap(item)
      }
      .toList
    override val publishStatus: zio.aws.connect.model.RulePublishStatus =
      zio.aws.connect.model.RulePublishStatus.wrap(impl.publishStatus())
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val lastUpdatedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val lastUpdatedBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.lastUpdatedBy())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Rule
  ): zio.aws.connect.model.Rule.ReadOnly = new Wrapper(impl)
}
