package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleAction(
    actionType: zio.aws.connect.model.ActionType,
    taskAction: Optional[zio.aws.connect.model.TaskActionDefinition] =
      Optional.Absent,
    eventBridgeAction: Optional[
      zio.aws.connect.model.EventBridgeActionDefinition
    ] = Optional.Absent,
    assignContactCategoryAction: Optional[
      zio.aws.connect.model.AssignContactCategoryActionDefinition
    ] = Optional.Absent,
    sendNotificationAction: Optional[
      zio.aws.connect.model.SendNotificationActionDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RuleAction = {
    import RuleAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RuleAction
      .builder()
      .actionType(actionType.unwrap)
      .optionallyWith(taskAction.map(value => value.buildAwsValue()))(
        _.taskAction
      )
      .optionallyWith(eventBridgeAction.map(value => value.buildAwsValue()))(
        _.eventBridgeAction
      )
      .optionallyWith(
        assignContactCategoryAction.map(value => value.buildAwsValue())
      )(_.assignContactCategoryAction)
      .optionallyWith(
        sendNotificationAction.map(value => value.buildAwsValue())
      )(_.sendNotificationAction)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RuleAction.ReadOnly =
    zio.aws.connect.model.RuleAction.wrap(buildAwsValue())
}
object RuleAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RuleAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RuleAction =
      zio.aws.connect.model.RuleAction(
        actionType,
        taskAction.map(value => value.asEditable),
        eventBridgeAction.map(value => value.asEditable),
        assignContactCategoryAction.map(value => value.asEditable),
        sendNotificationAction.map(value => value.asEditable)
      )
    def actionType: zio.aws.connect.model.ActionType
    def taskAction
        : Optional[zio.aws.connect.model.TaskActionDefinition.ReadOnly]
    def eventBridgeAction
        : Optional[zio.aws.connect.model.EventBridgeActionDefinition.ReadOnly]
    def assignContactCategoryAction: Optional[
      zio.aws.connect.model.AssignContactCategoryActionDefinition.ReadOnly
    ]
    def sendNotificationAction: Optional[
      zio.aws.connect.model.SendNotificationActionDefinition.ReadOnly
    ]
    def getActionType: ZIO[Any, Nothing, zio.aws.connect.model.ActionType] =
      ZIO.succeed(actionType)
    def getTaskAction: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("taskAction", taskAction)
    def getEventBridgeAction: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EventBridgeActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("eventBridgeAction", eventBridgeAction)
    def getAssignContactCategoryAction: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.AssignContactCategoryActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "assignContactCategoryAction",
      assignContactCategoryAction
    )
    def getSendNotificationAction: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.SendNotificationActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sendNotificationAction",
      sendNotificationAction
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RuleAction
  ) extends zio.aws.connect.model.RuleAction.ReadOnly {
    override val actionType: zio.aws.connect.model.ActionType =
      zio.aws.connect.model.ActionType.wrap(impl.actionType())
    override val taskAction
        : Optional[zio.aws.connect.model.TaskActionDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskAction())
        .map(value => zio.aws.connect.model.TaskActionDefinition.wrap(value))
    override val eventBridgeAction
        : Optional[zio.aws.connect.model.EventBridgeActionDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBridgeAction())
        .map(value =>
          zio.aws.connect.model.EventBridgeActionDefinition.wrap(value)
        )
    override val assignContactCategoryAction: Optional[
      zio.aws.connect.model.AssignContactCategoryActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assignContactCategoryAction())
      .map(value =>
        zio.aws.connect.model.AssignContactCategoryActionDefinition.wrap(value)
      )
    override val sendNotificationAction: Optional[
      zio.aws.connect.model.SendNotificationActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sendNotificationAction())
      .map(value =>
        zio.aws.connect.model.SendNotificationActionDefinition.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RuleAction
  ): zio.aws.connect.model.RuleAction.ReadOnly = new Wrapper(impl)
}
